<?php if (!defined('ABSPATH')) exit; ?>
<div class="ehm-glass-two-col ehm-color-<?php echo esc_attr($data['color']); ?>">
    
    <?php if (!empty($data['image'])): ?>
        <div class="ehm-glass-image" 
             style="background-image:url('<?php echo esc_url($data['image']); ?>')"></div>
    <?php endif; ?>

    <div class="ehm-glass-content">
        <?php if (!empty($data['title'])): ?>
            <h3><?php echo esc_html($data['title']); ?></h3>
        <?php endif; ?>

        <p>
            <?php
            if (!empty($data['description'])) {
                echo esc_html($data['description']);
            } elseif (!empty($data['desc'])) {
                echo esc_html($data['desc']);
            }
            ?>
        </p>

        <?php if (!empty($data['cta_text']) && !empty($data['permalink'])): ?>
            <a href="<?php echo esc_url($data['permalink']); ?>" 
               class="ehm-cta-button" target="_blank" rel="noopener">
               
                <?php if (!empty($data['icon']) && $data['icon_position'] === 'left'): ?>
                    <span class="dashicons <?php echo esc_attr($data['icon']); ?>" style="vertical-align:middle; margin-right:5px;"></span>
                <?php endif; ?>

                <?php echo esc_html($data['cta_text']); ?>
                
                <?php if (!empty($data['icon']) && $data['icon_position'] === 'right'): ?>
                    <span class="dashicons <?php echo esc_attr($data['icon']); ?>" style="vertical-align:middle; margin-left:5px;"></span>
                <?php endif; ?>

            </a>
        <?php endif; ?>
    </div>
</div>
